jQuery(document).ready(function($) {

    $('.new_cf').on('click', function(){
        last_cf_id++;
        var html = '<div class="row">';
            html += '<div class="value"><input type="text" name="wc_amocrm[cf]['+last_cf_id+']" value="" placeholder="my_filed"></div>';
            html += '<div class="value"><span class="remove">'+lang_delete+'</span></div>';
        html += '</div>';
        $('#cf_fields').append(html);
    });

    $('#select-orders').on('change', function(){
        var order_id = $(this).val();
        getOrder(order_id);

    });
    
    getOrder($('#select-orders').val());

    function getOrder(order_id){
        if(order_id > 0){
            $.ajax({
                url : ajaxurl,
                type: 'post',
                data: {
                    action: 'orders_'+widget_code,
                    order_id: order_id
                },
                dataType: 'json',
                success: function(data) {
                    $.each(data, function(field_key, field_value){
                        $('#order_field_'+field_key).text(field_value);
                    });
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        }
    }

    $('.nav-tabs li a').on('click', function(e){
        e.stopPropagation(); 
    	e.preventDefault();
        $('.nav-tabs li').removeClass('active');
        var id = $(this).attr('href');
        $(this).parent().addClass('active');
        $('.tab-content .tab-pane').removeClass('active');
        $('.tab-content ' + id).addClass('active');
    });

    $('.new_tag_lead').on('click', function(){
        var new_tag = '<div class="row"> <div class="value"> <input type="text" name="wc_amocrm[tags][lead][]" value=myshop.com"> </div> <div class="value"><span class="remove">'+lang_delete+'</span></div> </div>'
        $('.tags_lead').append(new_tag);
    });

    $('.new_tag_contact').on('click', function(){
        var new_tag = '<div class="row"> <div class="value"> <input type="text" name="wc_amocrm[tags][contact][]" value="myshop.com"> </div> <div class="value"><span class="remove">'+lang_delete+'</span></div> </div>'
        $('.tags_contact').append(new_tag);
    });
   
    $('.new_tag_company').on('click', function(){
        var new_tag = '<div class="row"> <div class="value"> <input type="text" name="wc_amocrm[tags][company][]" value="myshop.com"> </div> <div class="value"><span class="remove">'+lang_delete+'</span></div> </div>'
        $('.tags_company').append(new_tag);
    });

    $('.tags_lead,.tags_contact,.tags_company,#cf_fields').on('click', '.remove', function(){
        $(this).parents('.row').remove();
    });

    changePipeline(pipeline_id, pipeline_status);

    $('#pipeline_id').on('change', function(){
        var pipeline_id = $(this).val(); 
        changePipeline(pipeline_id, pipeline_status);
    });
    
    function changePipeline(pipeline_id = false, status = false){
        var options = '<option value="0">'+lang_not_selected+'</option>';

        if( (pipeline_id in pipelines) && ('statuses' in pipelines[pipeline_id]) ){
            let statuses = Object.values(pipelines[pipeline_id]['statuses']).sort((a, b) => a.sort - b.sort); // сортируем статусы
            $.each(statuses, function(key, value) {
                options += '<option value="'+value.id+'">'+value.name+'</option>'
            }); 
        }

          $.each(order_statuses, function(index, status){
            $('#wc_status_'+index).html(options);
            if(index in wc_statuses && wc_statuses[index] !== '' ){
                $('#wc_status_'+index+' option[value='+wc_statuses[index]+']').attr('selected', 'selected');
            }

        });
        $('select').trigger("chosen:updated");
    }

    $(document).on('click', '.export', function(){
        $('.tab-content .progress-bar').css('width', '0%').text('0%');
        var orders = $('.orders_export input[name="orders[]"]:checked').map(function() {
            return this.value;
        }).get();
        if(orders.length){
            $.ajax({
                url : ajaxurl,
                type: 'post',
                data: {
                    action: 'export_'+widget_code,
                    orders: orders,
                },
                dataType: 'json',
                success: function(data) {
                    $('.tab-content .progress-bar').css('width', '100%').text('100%');
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        }else{
            //$('.tab-content .progress-bar').css('width', '0%').text('0%');
        }
    });

    $(document).on('click', '.pagination a', function(e){
        e.stopPropagation();
        e.preventDefault();
        var href = $(this).attr('href');
        $('#tab-export').load(href + ' #tab-export>*');
    });

    $('select').chosen({
        disable_search_threshold: 10,
        width: '100%',
        allow_single_deselect: true,
        no_results_text: lang_not_found
    });
});