<?php require_once (__DIR__ . '/title.php'); ?>

<div class="wrap">
    <div class="alert_list">
        <?php if( isset($version) and (self::CURRENT_VERSION !== $version)){ ?>
        <div class="alert">Ваша версия плагина устарела, рекомендуем <a target="_blank" href="https://crmapp.store/widget/woocommerce-wordpress">скачать новую версию</a> и обновить плагин.</div>
        <?php } ?>
    </div>
</div>

<form action="<?= admin_url( 'admin.php?page='.self::PAGE_ID, 'https' ) ?>" method="post">
    <input type="hidden" name="action" value="update">
    <input type="hidden" name="nonce" value="<?= wp_create_nonce(self::PLUGIN_NAME); ?>">

    <div class="wrap">

        <div class="card" style="max-width:100%">
            <div class="panel-body">

                <ul class="nav nav-tabs">
                    <li><a href="#tab-header"><?= $this->lang['main'] ?></a></li>
                    <li><a href="#tab-sync"><?= $this->lang['synchronization'] ?></a></li>
                    <li><a href="#tab-cf_fields"><?= $this->lang['custom_fields'] ?></a></li>
                    <li><a href="#tab-constructor"><?= $this->lang['builder'] ?></a></li>
                    <li><a href="#tab-note"><?= $this->lang['note'] ?></a></li>
                    <li><a href="#tab-task"><?= $this->lang['task'] ?></a></li>
                    <li><a href="#tab-tags"><?= $this->lang['tags'] ?></a></li>
                    <li><a href="#tab-export"><?= $this->lang['export'] ?></a></li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane" id="tab-header">

                        <div class="row">
                            <div class="name"><?= $this->lang['send_amocrm'] ?></div>
                            <div class="value">
                                <select name="<?= self::PLUGIN_NAME ?>[plugin_status]">
                                    <option value="1" <?= $plugin_settings['plugin_status'] ? 'selected' : '' ?>><?= $this->lang['yes'] ?></option>
                                    <option value="0" <?= !$plugin_settings['plugin_status'] ? 'selected' : '' ?>><?= $this->lang['no'] ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="name"><?= $this->lang['delay_before_send'] ?></div>
                            <div class="value">
                                <input type="number" class="delay_send_amo" min="0" name="<?= self::PLUGIN_NAME ?>[delay_send_amo]" value="<?= $plugin_settings['delay_send_amo'] ?>">
                            </div>
                            <div class="value">
                                <?= $this->lang['text_delay_before_send'] ?>
                            </div>
                        </div>

                        <hr>

                        <p><b><?= $this->lang['lead'] ?></b></p>
                        <div class="row">
                            <div class="name"><?= $this->lang['lead_name'] ?></div>
                            <div class="value">
                                <input type="text" name="<?= self::PLUGIN_NAME ?>[lead_name]" value="<?= $plugin_settings['lead_name'] ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="name"><?= $this->lang['responsible_list'] ?></div>
                            <div class="value">
                                <select id="responsible_user_id" name="<?= self::PLUGIN_NAME ?>[responsible_list][]"  multiple data-placeholder="<?= $this->lang['select'] ?>">
                                    <?php foreach($managers as $manager_id => $manager_name){ ?>
                                        <option value="<?= $manager_id ?>" <?= (in_array($manager_id, $plugin_settings['responsible_list']) ? 'selected' : '') ?> ><?= $manager_name ?></option>
                                    <?php } ?>
                                </select>                            
                            </div>
                        </div>
                       
                        <div class="row">
                            <div class="name"><?= $this->lang['add_products'] ?></div>
                            <div class="value">
                                <select id="products" name="<?= self::PLUGIN_NAME ?>[products]">
                                    <option value="1" <?= $plugin_settings['products'] == 1 ? 'selected' : ''; ?>><?= $this->lang['yes'] ?></option>
                                    <option value="0" <?= $plugin_settings['products'] == 0 ? 'selected' : ''; ?>><?= $this->lang['no'] ?></option>
                                </select>                            
                            </div>
                        </div>

                        <hr>
                        <p><b><?= $this->lang['duplicate_control'] ?></b></p>

                        <div class="row">
                            <div class="name"><?= $this->lang['status'] ?></div>
                            <div class="value">
                                <select name="<?= self::PLUGIN_NAME ?>[antidub][status]">
                                    <option value="1" <?=  $plugin_settings['antidub']['status'] ? 'selected' : '' ?> ><?= $this->lang['enabled'] ?></option>
                                    <option value="0" <?= !$plugin_settings['antidub']['status'] ? 'selected' : '' ?> ><?= $this->lang['disabled'] ?></option>
                                </select>                           
                            </div>
                        </div>

                        <div class="row">
                            <div class="name"><?= $this->lang['do_not_overwrite_fields'] ?></div>
                            <div class="value">
                                <select class="chosen-select" name="<?= self::PLUGIN_NAME ?>[antidub][ignore][]" multiple data-placeholder="<?= $this->lang['select'] ?>">
                                    <?php if($antidub_fields){ ?>
                                        <?php foreach($antidub_fields as $field_id => $field_name){ ?>
                                        <option value="<?= $field_id ?>" <?= ($ignore and in_array($field_id, $ignore)) ? 'selected' : '' ?>><?= $field_name ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>                           
                            </div>
                        </div>

                        <div class="row">
                            <div class="name"><?= $this->lang['reassign_responsible'] ?></div>
                            <div class="value">
                                <select name="<?= self::PLUGIN_NAME ?>[antidub][change_responsible]">
                                    <option value="1" <?=  $change_responsible ? 'selected' : '' ?> ><?= $this->lang['yes'] ?></option>
                                    <option value="0" <?= !$change_responsible ? 'selected' : '' ?> ><?= $this->lang['no'] ?></option>
                                </select>                           
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="tab-sync">

                        <div class="row">
                            <div class="name"><?= $this->lang['pipeline'] ?></div>
                            <div class="value">
                                <select id="pipeline_id" name="<?= self::PLUGIN_NAME ?>[pipeline_id]">
                                    <?php foreach($amoPipelines as $pipeline_id => $pipeline){ ?>
                                    <option value="<?= $pipeline_id ?>" <?= $plugin_settings['pipeline_id'] == $pipeline_id ? 'selected' : '' ?> ><?= $pipeline['name'] ?></option>
                                    <?php } ?>
                                </select>                            
                            </div>
                        </div>

                        <?php foreach($wc_order_statuses as $wc_order_status_key => $wc_order_status){ ?>
                        <div class="row">
                            <div class="name">
                                <mark class="order-status <?= str_replace('wc', 'status', $wc_order_status_key); ?> tips"><span><?= $wc_order_status ?></span></mark>
                            </div>
                            <div class="value">
                                <select id="wc_status_<?= $wc_order_status_key ?>" name="<?= self::PLUGIN_NAME ?>[wc_statuses][<?= $wc_order_status_key ?>]">
                                    <option value="0" ><?= $this->lang['not_loaded'] ?></option>
                                </select>                            
                            </div>
                        </div>
                        <?php } ?>
                    </div>

                    <div class="tab-pane" id="tab-cf_fields">
                        <div class="row">
                            <i><?= $this->lang['custom_fields_text'] ?></i>
                        </div>
                        <div id="cf_fields">
                            <?php if($cf){ ?>
                                <?php foreach($cf as $cf_key => $cf_key_name){ ?>
                                    <div class="row">
                                        <div class="value"><input type="text" name="<?= self::PLUGIN_NAME ?>[cf][<?= $cf_key ?>]" value="<?= $cf_key_name ?>" placeholder="my_filed"></div>
                                        <div class="value"><span class="remove"><?= $this->lang['delete'] ?></span></div>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                        </div>
                        <div class="row">
                            <span class="btn btn-green new_cf"><?= $this->lang['add'] ?></span>
                        </div>
                    </div>

                    <div class="tab-pane" id="tab-constructor">
                        
                        <div class="row">
                            <div class="name">
                                <?= $this->lang['last_orders'] ?>
                            </div>
                            <div class="value">
                                <select id="select-orders" name="<?= self::PLUGIN_NAME ?>[orders]">
                                    <?php foreach($orders as $order){ $order_data = $order->get_data() ?>
                                    <option value="<?= $order_data['id'] ?>"><?= $this->lang['order'] ?> #<?= $order_data['id'] ?></option>
                                    <?php } ?>
                                </select>                            
                            </div>
                        </div>
                            
                        <div class="row">
                            <div class="name"><b><?= $this->lang['order_field'] ?></b></div>
                            <div class="value"><b><?= $this->lang['kommo_field'] ?></b></div>
                            <div class="value"><b><?= $this->lang['order_field_value'] ?></b></div>
                        </div>

                        <?php foreach($order_fields as $order_field){ ?>
                            <div class="row">
                                <div class="name">
                                    <?= $order_field ?>
                                </div>
                                <div class="value">
                                    <select name="<?= self::PLUGIN_NAME ?>[comparison][<?= $order_field ?>]">
                                        <option value="0" <?= !isset($plugin_settings['comparison'][$order_field]) ? 'selected' : '' ?> ><?= $this->lang['not_selected'] ?></option>
                                        <?php foreach($amo_settings['fields'] as $field_key => $field_name){ ?>
                                            <option value="<?= $field_key ?>" <?= (isset($plugin_settings['comparison'][$order_field]) and $plugin_settings['comparison'][$order_field] === $field_key) ? 'selected' : '' ?> ><?= $field_name ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div id="order_field_<?= $order_field ?>" class="value"></div>
                            </div>
                        <?php } ?>

                    </div>

                    <div class="tab-pane" id="tab-note">

                        <div class="row">
                            <div class="name"><?= $this->lang['add_products_note'] ?></div>
                            <div class="value">
                                <label><input type="radio" name="<?= self::PLUGIN_NAME ?>[product_link]" value="1" <?= $plugin_settings['product_link'] ? 'checked' : '' ?>><?= $this->lang['yes'] ?></label>
                                <label><input type="radio" name="<?= self::PLUGIN_NAME ?>[product_link]" value="0" <?= !$plugin_settings['product_link'] ? 'checked' : '' ?>><?= $this->lang['no'] ?></label>
                            </div>
                        </div>

                        <div class="row">
                            <div class="name"><?= $this->lang['create_lead'] ?></div>
                            <div class="value">
                                <label><input type="radio" name="<?= self::PLUGIN_NAME ?>[note_status]" value="1" <?= $plugin_settings['note_status'] ? 'checked' : '' ?>><?= $this->lang['yes'] ?></label>
                                <label><input type="radio" name="<?= self::PLUGIN_NAME ?>[note_status]" value="0" <?= !$plugin_settings['note_status'] ? 'checked' : '' ?>><?= $this->lang['no'] ?></label>
                            </div>
                        </div>

                        <div class="row note_template">
                            <div class="name"><?= $this->lang['note_template'] ?></div>
                            <div class="value">
                                <textarea id="note_template" name="<?= self::PLUGIN_NAME ?>[note_template]" rows="15" class="form-control"><?= $plugin_settings['note_template'] ?></textarea>
                            </div>
                        </div>

                    </div>

                    <div class="tab-pane" id="tab-task">

                        <div class="row">
                            <div class="value"><b><?= $this->lang['create_task'] ?></b></div>
                            <div class="value"><b><?= $this->lang['task_type'] ?></b></div>
                            <div class="value"><b><?= $this->lang['task_description'] ?></b></div>
                            <div class="value"><b><?= $this->lang['task_deadline'] ?></b></div>
                            <div class="value"></div>
                        </div>

                        <hr>
                        
                        <div class="task">
                        <?php if($task){ ?>
                                <div class="row">

                                    <div class="value">
                                        <select name="<?= self::PLUGIN_NAME ?>[task][status]">
                                            <option value="1" <?= (int)$task['status'] == 1 ? 'selected' : '' ?> ><?= $this->lang['yes'] ?></option>
                                            <option value="0" <?= (int)$task['status'] == 0 ? 'selected' : '' ?> ><?= $this->lang['no'] ?></option>
                                        </select>  
                                    </div>

                                    <div class="value">
                                        <select name="<?= self::PLUGIN_NAME ?>[task][type]">
                                            <?php foreach($task_types as $task_type){ ?>
                                                <option value="<?= $task_type['id'] ?>" <?= $task['type'] == $task_type['id'] ? 'selected' : '' ?> ><?= $task_type['name'] ?></option>
                                            <?php } ?>
                                        </select>     
                                    </div>

                                    <div class="value">
                                        <input type="text" name="<?= self::PLUGIN_NAME ?>[task][text]" value="<?= $task['text'] ?>">
                                    </div>

                                    <div class="value">
                                        <input type="text" name="<?= self::PLUGIN_NAME ?>[task][complete_till]" value="<?= $task['complete_till'] ?>">
                                    </div>

                                    <div class="value">
                                        <select id="task" name="<?= self::PLUGIN_NAME ?>[task][time]">
                                            <?php foreach($task_times as $task_value => $task_name){ ?>
                                            <option value="<?= $task_value ?>" <?= $task['time'] == $task_value ? 'selected' : '' ?> ><?= $task_name ?></option>
                                            <?php } ?>
                                        </select>  
                                    </div>


                                </div>

                        <?php } ?>
                        </div>

                    </div>

                    <div class="tab-pane" id="tab-tags">
                    
                        <p><b><?= $this->lang['tags_lead'] ?></b></p>
                        <div class="tags_lead">
                            <?php if($plugin_settings['tags']['lead']){ ?>
                                <?php foreach($plugin_settings['tags']['lead'] as $tag){ ?>
                                <div class="row">
                                    <div class="value">
                                        <input type="text" name="<?= self::PLUGIN_NAME ?>[tags][lead][]" value="<?= $tag ?>">    
                                    </div>
                                    <div class="value"><span class="remove"><?= $this->lang['delete'] ?></span></div>
                                </div>
                                <?php } ?>
                            <?php } ?>
                        </div>

                        <div class="row">
                            <span class="btn btn-green new_tag_lead"><?= $this->lang['add'] ?></span>
                        </div>

                        <hr>
                        <p><b><?= $this->lang['tags_contact'] ?></b></p>
                        <div class="tags_contact">
                            <?php if($plugin_settings['tags']['contact']){ ?>
                                <?php foreach($plugin_settings['tags']['contact'] as $tag){ ?>
                                <div class="row">
                                    <div class="value">
                                        <input type="text" name="<?= self::PLUGIN_NAME ?>[tags][contact][]" value="<?= $tag ?>">    
                                    </div>
                                    <div class="value"><span class="remove"><?= $this->lang['delete'] ?></span></div>
                                </div>
                                <?php } ?>
                            <?php } ?>
                        </div>

                        <div class="row">
                            <span class="btn btn-green new_tag_contact"><?= $this->lang['add'] ?></span>
                        </div>

                        <hr>
                        <p><b><?= $this->lang['tags_company'] ?></b></p>
                        <div class="tags_company">
                            <?php if($plugin_settings['tags']['company']){ ?>
                                <?php foreach($plugin_settings['tags']['company'] as $tag){ ?>
                                <div class="row">
                                    <div class="value">
                                        <input type="text" name="<?= self::PLUGIN_NAME ?>[tags][company][]" value="<?= $tag ?>">    
                                    </div>
                                    <div class="value"><span class="remove"><?= $this->lang['delete'] ?></span></div>
                                </div>
                                <?php } ?>
                            <?php } ?>
                        </div>

                        <div class="row">
                            <span class="btn btn-green new_tag_company"><?= $this->lang['add'] ?></span>
                        </div>

                    </div>

                    <div class="tab-pane" id="tab-export">
                        <table class="table orders">
                            <thead>
                            <tr>
                                <td style="width: 1px;" class="text-center">
                                    <input type="checkbox" onclick="jQuery('input[name^=orders]').prop('checked', this.checked);">
                                </td>
                                <td class="text-right"><?= $this->lang['order'] ?> #</td>
                                <td class="text-left"><?= $this->lang['customer'] ?></td>
                                <td class="text-left"><?= $this->lang['status'] ?></td>
                                <td class="text-left"><?= $this->lang['total'] ?></td>
                                <td class="text-left"><?= $this->lang['added'] ?></td>
                                <td class="text-left"><?= $this->lang['updated'] ?></td>
                            </tr>
                            </thead>
                            <tbody class="orders_export">
                                <?php if($orders){ ?>
                                <?php foreach($orders as $order){ $order_data = $order->get_data() ?>
                                <tr>
                                    <td style="width: 1px;" class="text-center">
                                        <input type="checkbox" name="orders[]" value="<?= $order_data['id'] ?>">
                                    </td>
                                    <td class="text-right"><?= $order_data['id'] ?></td>
                                    <td class="text-left"><?= $order_data['billing']['first_name'] . ' ' . $order_data['billing']['last_name'] ?></td>
                                    <td class="text-left"><?= $wc_order_statuses['wc-'.$order_data['status']] ?></td>
                                    <td class="text-left"><?= $order_data['total'] . ' ' . $order_data['currency'] ?></td>
                                    <td class="text-left"><?= $order_data['date_created']->date('d.m.Y H:i:s') ?></td>
                                    <td class="text-left"><?= $order_data['date_modified']->date('d.m.Y H:i:s') ?></td>
                                </tr>
                                <?php }  ?>
                                <?php } ?>
                            </tbody>
                        </table>


                        <div class="progress-container">
                            <div class="progress">
                                <div class="progress-bar progress-bar-success" role="progressbar" style="min-width: 2em; width: 0%;">0%</div>
                            </div>
                            <button type="button" class="btn export"><?= $this->lang['export_btn'] ?></button>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    <button type="submit" class="button button-primary button-large"><?= $this->lang['save'] ?></button>
</form>

<script>
        var widget_code = '<?= $widget_code ?>';
        var pipelines = <?= json_encode($amo_settings['pipelines']) ?>;
        var pipeline_id = <?= $plugin_settings['pipeline_id'] ?>;
        var pipeline_status = <?= $plugin_settings['p_status'] ?>;
        var order_statuses = <?= json_encode($wc_order_statuses) ?>;
        var wc_statuses = <?= json_encode($plugin_settings['wc_statuses']) ?>;
        var amo_fields = <?= json_encode($amoFields) ?>;   

        var amo_managers = <?= json_encode($managers) ?>;

        var last_cf_id = <?= $last_cf_id?>;
        var order_fields = <?= json_encode($order_fields) ?>;

        var lang_not_selected = '<?= $this->lang['not_selected'] ?>';
        var lang_not_found = '<?= $this->lang['not_found'] ?>';
        var lang_delete = '<?= $this->lang['delete'] ?>';
        
        // табы
        jQuery('#<?= $tab ?>').addClass('active');
        jQuery('.nav-tabs a[href=#<?= $tab ?>]').parent().addClass('active');

</script>