jQuery(document).ready(function($) {

    $('.action_delete_leads').on('click', function(){
        $.ajax({
            url : ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: $('.leads_list input[type=checkbox]:checked.select_lead, .leads_list input[type=hidden]'),
            success:function(data){
                if(data.status){
                    $.each(data.delete, function(i, lead_id){
                        $('#select-all-'+lead_id).parents('tr').remove();
                    })
                }
            }
        });
    });

    $('#select-all').on('change', function(){
        $('.select_lead').prop('checked', $(this).is(':checked'));
    });

    $('form #export').on('click', function(e){
        e.preventDefault();
        var button = $(this);
        var data = button.parents('form').serializeArray();
        button.append('<span class="dashicons dashicons-update spin margin-left-5"></span>');
        $('form .result').removeClass('text_green').removeClass('text_red');
        $('.result').text('');
        $.ajax({
            url : ajaxurl,
            type: 'POST',
            dataType: 'json',
            data:data,
            success:function(data){
                if(data.status){
                    $('form .result').addClass('text_green');
                }else{
                    $('form .result').addClass('text_red');
                }
                $('.button .dashicons').remove();
                $('form .result').text(data.message);
            }
        });

    });

    $('.form_tags span').on('click', function(){
        var tag = '{{'+$(this).text()+'}}';
        var container = $(this).parents('tr').find('input, textarea');
        container.val( container.val() + tag );
    });

    $('.newtag').on('click', function(){
        var newTag = '<tr> <th></th> <td><input type="text" name="'+$(this).data('name')+'[tags][]" value=""></td> <td><div class="button button-primary button-large removetag">'+delete_text+'</div></td> </tr>';
        $(this).parents('tr').before(newTag);
    });
    

    $(document).on('click', '.removetag', function(){
        $(this).parents('tr').remove();
    });

    changePipeline(pipeline_id, pipeline_status);

    $('#pipeline_id').on('change', function(){
        var pipeline_id = $(this).val(); 
        changePipeline(pipeline_id, pipeline_status);
    });
    
    function changePipeline(pipeline_id = false, status = 0){
        if(!pipeline_id){
            return false;
        }

        $('.pipeline_select_dropdown').empty();
        
        var options = '<li data-status_id="0" class="no-select" data-color="#00000000">'+not_selected_text+'</li>';
        if( (pipeline_id in pipelines) && ('statuses' in pipelines[pipeline_id]) ){
            options += '<li data-status_id="unsortered_'+pipeline_id+'" class="no-select" data-color="#c1c1c1" style="background-color:#c1c1c1">'+unsortered_text+'</li>';
            let statuses = Object.values(pipelines[pipeline_id]['statuses']).sort((a, b) => a.sort - b.sort); // сортируем статусы
            $.each(statuses, function(key, p_status) {
                options += '<li data-status_id="'+p_status.id+'" class="no-select" data-color="'+p_status.color+'" style="background-color:'+p_status.color+'">'+p_status.name+'</li>'
            }); 
        }

        $('#p_status .pipeline_select_dropdown').html(options);

        if(status){ 
            let selected_item = $('.pipeline_select_dropdown [data-status_id='+status+']');
            if(!selected_item.length){
                selected_item = $('.pipeline_select_dropdown [data-status_id=0]');
            }
            selected_item.addClass('active');
            $('.pipeline_select_title').text(selected_item.text());
            $('.pipeline_select_title').css('background-color', selected_item.data('color'));
            $('#p_status input').val(selected_item.data('status_id'));
        }
    }

    $('.pipeline_select_dropdown').on('click', 'li', function(){ // клик на этап сделки
        $('.pipeline_select_title').text($(this).text());
        $('.pipeline_select_title').css('background-color', $(this).data('color'));
        $('#p_status input').val($(this).data('status_id'));
        $('#p_status .dropdown-menu').addClass('hidden');
        $('.pipeline_select_dropdown li').removeClass('active');
        $(this).addClass('active');
    });

    $('#p_status').on('click', '.pipeline_select_title', function(){ // открываем dropdown
        $('.dropdown-menu').toggleClass('hidden');
    });

   $(document).on('click', function(event) { // клик был вне меню
        if ($('#p_status').has(event.target).length === 0) {
            $('.dropdown-menu').addClass('hidden');
        }
    });

    $('select').chosen({
        disable_search_threshold: 5,
        width: '100%',
        allow_single_deselect: true,
        no_results_text: not_found_text,
    });

});