<?php require_once (__DIR__ . '/title.php'); ?>

<div class="wrap">
    <div class="alert_list">
        <?php if( isset($version) and (self::CURRENT_VERSION !== $version)){ ?>
        <div class="alert">Ваша версия плагина устарела, рекомендуем <a target="_blank" href="https://crmapp.store/widget/<?= self::PLUGIN_KEY_URL ?>">скачать новую версию</a> и обновить плагин.</div>
        <?php } ?>
    </div>
</div>

<div class="wrap">
    <div class="card" style="max-width:100%">
        <h2 class="title"><?= $this->translate('all_forms'); ?></h2>
        <hr>
        <div class="row">

            <table class="wp-list-table widefat fixed striped table-view-list">
                <thead>
                    <tr>
                        <th class="column-name">
                            <span><?= $this->translate('form_name'); ?></span>
                        </th>
                        <th class="manage-column column-author">
                            <span><?= $this->translate('leads_count'); ?></span>
                        </th>
                        <th class="manage-column column-date">
                            <span><?= $this->translate('created_at'); ?></span>
                        </th>
                    </tr>
                </thead>

                <tbody id="the-list">
                    <?php if($forms){ ?>
                    <?php foreach($forms as $form){ ?>
                    <tr>
                        <td class="column-name">
                            <a href="<?= esc_url(admin_url('admin.php?page='.self::PAGE_ID.'&form_id='.$form['ID'])); ?>" title="<?= $this->translate('edit_form'); ?>">
                                <strong><?= esc_html($form['post_title']); ?></strong>
                            </a>
                        </td>
                        <td class="column-author"><?= esc_html($this->get_leads_count($form['ID'])); ?></td>
                        <td class="column-date"><?= esc_html($form['post_date']); ?></td>
                    </tr>
                    <?php } ?>
                    <?php } ?>
                </tbody>
            </table>

        </div>
    </div>

    <div class="card" style="max-width:100%">
        <h2 class="title"><?= $this->translate('my_leads'); ?></h2>
        <hr>
        <div class="row">
            <table class="wp-list-table widefat fixed striped table-view-list posts leads_list">
                <thead>
                    <tr>
                        <td class="manage-column column-cb check-column">
                            <input id="select-all" type="checkbox">
                            <label for="select-all" class="select-all"></label>
                        </td>
                        <th class="column-name">
                            <span>#</span>
                        </th>
                        <th class="column-author"><?= $this->translate('form'); ?></th>
                        <th class="column-date">
                            <span><?= $this->translate('created_at'); ?></span>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($leads){ ?>
                        <?php foreach($leads as $lead){ ?>
                        <tr>
                            <th class="check-column">
                                <input class="select_lead" id="select-all-<?= $lead['ID'] ?>" type="checkbox" name="leads_id[]" value="<?= $lead['ID'] ?>">
                                <label for="select-all-<?= $lead['ID'] ?>" class="select_lead_id"></label>
                            </th>
                            <th class="column-name">
                                <a href="<?= admin_url( 'admin.php?page='.self::PAGE_ID.'&lead_id='.$lead['ID'], 'https' ) ?>" title="<?= $this->translate('view_lead'); ?>">
                                    <strong><?= $this->translate('lead'); ?> # <?= $lead['ID'] ?></strong>
                                </a>
                            </th>
                            <th class="column-author">
                                <a href="<?= admin_url( 'admin.php?page='.self::PAGE_ID.'&form_id='.$lead['form_id'], 'https' ) ?>" title="<?= $this->translate('edit_form'); ?>">
                                    <?= $this->forms[$lead['form_id']]['post_title'] ?>
                                </a>
                            </th>
                            <th class="column-date"><?= date('d.m.Y H:i', strtotime($lead['date'])) ?></th>
                        </tr>
                        <?php } ?>
                    <?php } ?>
                    <input type="hidden" name="action" value="delete_lead_<?= self::PLUGIN_KEY ?>">
                    <input type="hidden" name="nonce" value="<?= wp_create_nonce(self::PLUGIN_KEY.'_delete_nonce'); ?>">
                </tbody>
            </table>
        </div>

        <div class="row">
            <div class="button action_delete_leads"><?= $this->translate('delete_selected'); ?></div>
        </div>
    </div>

    <form action="<?= admin_url( 'admin.php?page='.self::PAGE_ID, 'https' ) ?>" method="post">
        
        <input type="hidden" name="action" value="save_settings">
        <input type="hidden" name="nonce" value="<?= wp_create_nonce(self::PLUGIN_KEY.'_settings_page'); ?>">

            <div class="card" style="max-width:100%">
                <h2 class="title"><?= $this->translate('yandex_metrika'); ?></h2>
                <hr>
                <div class="ym_counter">
                    <div class="row">
                        <i><?= $this->translate('yandex_metrika_text'); ?></i>
                    </div>
                    <div class="row">
                        <div class="name"><?= $this->translate('yandex_metrika_counter_id'); ?></div>
                        <div class="value"><input type="text" name="<?= self::PLUGIN_KEY.'_settings' ?>[ym_counter]" value="<?= $settings['ym_counter'] ?>"></div>
                    </div>
                </div>
            </div>

            <br>
            <button type="submit" class="button button-primary button-large margin-left-0"><?= $this->translate('save'); ?></button>
    </form>
</div>

<script>
var pipelines = false;
var pipeline_id = false;
var pipeline_status = false;

var delete_text = '<?= $this->translate('delete') ?>';
var not_selected_text = '<?= $this->translate('not_selected') ?>';
var unsortered_text = '<?= $this->translate('unsortered') ?>';
var not_found_text = '<?= $this->translate('not_found') ?>';
</script>